(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     29545,        853]*)
(*NotebookOutlinePosition[     30199,        876]*)
(*  CellTagsIndexPosition[     30155,        872]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(\(nube = {{1, 1}, {2, 1.7}, {3, 0.7}, {4, 1}};\)\), "\n", 
    \(p[x_] = InterpolatingPolynomial[nube, x]\)}], "Input"],

Cell[BoxData[
    \(1 + \((\(\(0.7`\)\(\[InvisibleSpace]\)\) + \((\(-0.85`\) + 
                  0.5`\ \((\(-3\) + x)\))\)\ \((\(-2\) + x)\))\)\ \((\(-1\) + 
            x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[p[x]]\)], "Input"],

Cell[BoxData[
    \(\(-4.4`\) + 8.75`\ x - 3.85`\ x\^2 + 0.5`\ x\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[p[x], {x, 1, 4}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Thickness[0.004]}, 
        PlotRange \[Rule] {\(-0.3\), 2.2}, Ticks \[Rule] None, 
        AxesStyle \[Rule] {Thickness[0.003]}, 
        AxesOrigin \[Rule] {0.5, 0}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .79365 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.293651 0.31746 0.0952381 0.31746 [
[ -0.13642 -0.0015 0 0 ]
[ 1.0015 .79515 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .09524 m
1 .09524 L
s
-0.13492 0 m
-0.13492 .79365 L
s
0 0 m
1 0 L
1 .79365 L
0 .79365 L
closepath
clip
newpath
.004 w
.02381 .4127 m
.06244 .50045 L
.10458 .57298 L
.12507 .60016 L
.14415 .62101 L
.16371 .63815 L
.18221 .6506 L
.192 .65579 L
.20262 .66035 L
.21228 .66357 L
.2212 .66578 L
.22586 .66665 L
.23087 .66737 L
.23329 .66764 L
.2356 .66785 L
.23767 .66801 L
.23993 .66813 L
.24132 .66819 L
.24264 .66822 L
.24382 .66825 L
.2451 .66826 L
.24577 .66826 L
.2465 .66825 L
.24726 .66824 L
.24798 .66823 L
.24925 .6682 L
.25062 .66815 L
.2519 .66808 L
.25329 .668 L
.25582 .66782 L
.26055 .66733 L
.2654 .66666 L
.26995 .66586 L
.28033 .66347 L
.29044 .66039 L
.30133 .65629 L
.32137 .64675 L
.34247 .63413 L
.38058 .60553 L
.42114 .56845 L
.46019 .5281 L
.50169 .48223 L
.54167 .43706 L
.58013 .39451 L
.62105 .35213 L
.66046 .316 L
.69834 .28731 L
.71942 .27452 L
.73868 .26512 L
.74821 .26135 L
Mistroke
.7586 .25793 L
.76841 .25541 L
.77751 .2537 L
.7826 .25302 L
.78547 .25272 L
.7881 .25251 L
.79042 .25236 L
.79173 .2523 L
.79295 .25226 L
.79425 .25222 L
.79542 .2522 L
.79608 .25219 L
.79678 .25219 L
.79807 .2522 L
.79922 .25221 L
.8003 .25224 L
.80149 .25228 L
.80277 .25233 L
.80537 .25249 L
.80775 .25268 L
.81211 .25316 L
.81669 .25384 L
.82171 .25479 L
.82626 .25585 L
.83647 .25892 L
.84593 .26264 L
.85485 .26694 L
.8749 .27951 L
.89337 .29483 L
.93282 .34047 L
.97076 .40231 L
.97619 .4127 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{221.063, 175.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003M0000[a000`40O003h00OgGoo003MOol00=eo
o`00gGoo003MOol00=eoo`00gGoo003MOol00=eoo`00gGoo003MOol00003001oogoo0=Yoo`0000<0
07ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomo
o`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yo
o`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo0000
0`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001o
ogoo01Mool80005oo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<0
07ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomo
o`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yo
o`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo0000
0`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001o
ogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0
fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol0
0003001oogoo0:ioo`L002Eoo`0000<007ooOol0ZGoo1@001goo10008Goo00000`00Oomoo`2WOol2
000@Ool3000NOol00003001oogoo0:Eoo`8001Eoo`03001oogoo01]oo`0000<007ooOol0Xgoo0P00
67oo0P006goo00000`00Oomoo`2QOol2000LOol00`00Oomoo`0HOol00003001oogoo09moo`8001mo
o`03001oogoo01Moo`0000<007ooOol0WWoo00<007ooOol087oo0P005goo00000`00Oomoo`2MOol0
0`00Oomoo`0SOol00`00Oomoo`0DOol00003001oogoo09aoo`03001oogoo02Eoo`03001oogoo01=o
o`0000<007ooOol0VWoo0P00:Goo00<007ooOol04Woo00000`00Oomoo`2IOol00`00Oomoo`0ZOol0
0`00Oomoo`0AOol00003001oogoo09Qoo`03001oogoo02aoo`03001oogoo011oo`0000<007ooOol0
Ugoo00<007ooOol0;Woo00<007ooOol03goo00000`00Oomoo`2FOol00`00Oomoo`0_Ool00`00Oomo
o`0?Ool00003001oogoo09Eoo`03001oogoo035oo`03001oogoo00ioo`0000<007ooOol0U7oo00<0
07ooOol0<goo00<007ooOol03Goo00000`00Oomoo`2BOol2000gOol00`00Oomoo`0<Ool00003001o
ogoo095oo`03001oogoo03Qoo`03001oogoo00]oo`0000<007ooOol0T7oo00<007ooOol0>Goo00<0
07ooOol02goo00000`00Oomoo`2?Ool00`00Oomoo`0kOol00`00Oomoo`0:Ool00003001oogoo08io
o`03001oogoo03eoo`03001oogoo00Uoo`0000<007ooOol0SGoo00<007ooOol0?Woo00<007ooOol0
2Goo00000`00Oomoo`2<Ool00`00Oomoo`10Ool00`00Oomoo`08Ool00003001oogoo08]oo`03001o
ogoo049oo`03001oogoo00Moo`0000<007ooOol0RWoo00<007ooOol0@goo00<007ooOol01goo0000
0`00Oomoo`29Ool00`00Oomoo`15Ool00`00Oomoo`06Ool00003001oogoo08Qoo`03001oogoo04Mo
o`03001oogoo00Eoo`0000<007ooOol0Qgoo00<007ooOol0B7oo00<007ooOol01Goo00000`00Oomo
o`26Ool00`00Oomoo`1:Ool00`00Oomoo`04Ool00003001oogoo08Eoo`03001oogoo04aoo`03001o
ogoo00=oo`0000<007ooOol06goo00<007ooOol0IWoo00<007ooOol0CGoo00<007ooOol00goo0000
0`00Oomoo`0KOol00`00Oomoo`1VOol00`00Oomoo`1COol00003001oogoo01aoo`03001oogoo06Ao
o`03001oogoo05Aoo`0000<007ooOol077oo00<007ooOol0Hgoo00<007ooOol0EGoo00000`00Oomo
o`0MOol00`00Oomoo`1QOol00`00Oomoo`1FOol00003001oogoo01eoo`03001oogoo061oo`03001o
ogoo05Moo`0000<007ooOol07Woo00<007ooOol0GWoo00<007ooOol0F7oo00000`00Oomoo`0NOol0
0`00Oomoo`1MOol00`00Oomoo`1IOol00003001oogoo01moo`03001oogoo05]oo`03001oogoo05Yo
o`0000<007ooOol07goo00<007ooOol0FWoo00<007ooOol0Fgoo00000`00Oomoo`0POol00`00Oomo
o`1IOol00`00Oomoo`1KOol00003001oogoo021oo`03001oogoo05Qoo`03001oogoo05aoo`0000<0
07ooOol08Goo00<007ooOol0EWoo00<007ooOol0GGoo00000`00Oomoo`0QOol00`00Oomoo`1EOol0
0`00Oomoo`1NOol00003001oogoo029oo`03001oogoo05=oo`03001oogoo05moo`0000<007ooOol0
8Woo00<007ooOol0DWoo00<007ooOol0H7oo00000`00Oomoo`0SOol00`00Oomoo`1@Ool00`00Oomo
o`1QOol00003001oogoo02=oo`03001oogoo04moo`03001oogoo069oo`0000<007ooOol097oo00<0
07ooOol0CGoo00<007ooOol0Hgoo00000`00Oomoo`0TOol00`00Oomoo`1=Ool00`00Oomoo`1SOol0
0003001oogoo02Eoo`03001oogoo04]oo`03001oogoo06Aoo`0000<007ooOol09Goo00<007ooOol0
BWoo00<007ooOol0IGoo00000`00Oomoo`0VOol00`00Oomoo`18Ool00`00Oomoo`1VOol00003001o
ogoo02Ioo`03001oogoo04Moo`03001oogoo06Moo`0000<007ooOol09goo00<007ooOol0AGoo00<0
07ooOol0J7oo00000`00Oomoo`0XOol00`00Oomoo`13Ool00`00Oomoo`1YOol00003001oogoo02Qo
o`03001oogoo049oo`03001oogoo06Yoo`0000<007ooOol0:Goo00<007ooOol0?goo0P00KGoo0000
0`00Oomoo`0YOol00`00Oomoo`0nOol00`00Oomoo`1]Ool00003001oogoo02Yoo`03001oogoo03ao
o`03001oogoo06ioo`0000<007ooOol0:Woo00<007ooOol0>goo00<007ooOol0Kgoo00000`00Oomo
o`0[Ool00`00Oomoo`0iOol00`00Oomoo`1`Ool00003001oogoo02aoo`03001oogoo03Moo`03001o
ogoo075oo`0000<007ooOol0;7oo00<007ooOol0=Woo00<007ooOol0LWoo00000`00Oomoo`0]Ool0
0`00Oomoo`0dOol00`00Oomoo`1cOol00003001oogoo02ioo`03001oogoo039oo`03001oogoo07Ao
o`0000<007ooOol0;Woo00<007ooOol0<Goo00<007ooOol0MGoo00000`00Oomoo`0_Ool00`00Oomo
o`0_Ool00`00Oomoo`1fOol00003001oogoo031oo`03001oogoo02eoo`03001oogoo07Moo`0000<0
07ooOol0<Goo00<007ooOol0:Woo0P00NWoo00000`00Oomoo`0bOol00`00Oomoo`0XOol00`00Oomo
o`1jOol00003001oogoo03=oo`03001oogoo02Ioo`03001oogoo07]oo`0000<007ooOol0=7oo0P00
97oo0P00OWoo00000`00Oomoo`0fOol00`00Oomoo`0POol00`00Oomoo`1nOol00003001oogoo03Mo
o`03001oogoo01ioo`03001oogoo07moo`0000<007ooOol0>7oo0P0077oo0P00PWoo00000`00Oomo
o`0jOol2000GOol30024Ool00003001oogoo03aoo`80019oo`<008Moo`0000<007ooOol0?Woo0P00
3Woo0P00RWoo00000`00Oomoo`10Ool40006Ool4002<Ool00003001oogoo04Aoo`H0091oo`0000<0
07ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomo
o`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yo
o`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo0000
0`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001o
ogoo0=Yoo`0000<007ooOol0fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`0000<007ooOol0
fWoo00000`00Oomoo`3JOol00003001oogoo0=Yoo`00gGoo003MOol00=eoo`00gGoo003MOol00=eo
o`00gGoo003MOol00=eoo`00gGoo0000\
\>"],
  ImageRangeCache->{{{0, 220.063}, {174.438, 0}} -> {0.49526, -0.470663, \
0.0162885, 0.0162885}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = {{Dashing[{0.01, 0.01}], 
          Line[{{1, 0}, {1, 1}}]}, {Dashing[{0.01, 0.01}], 
          Line[{{4, 1}, {4, 0}}]}, {Dashing[{0.01, 0.01}], 
          Line[{{1.7, 0}, {1.7, 1.81}}]}, Line[{{1, 1.81}, {4, 1.81}}], 
        Text[a1, {1, \(-0.2\)}], Text[or, {0.2, \(-0.2\)}], 
        Text[a2, {4, \(-0.2\)}], Text[a4, {3.4, 1.1}], Text[a3, {1.1, 1}], 
        Text[a6, {2, 0.6}], Text[a5, {1.7, \(-0.2\)}], 
        Text[a7, {1.5, 2}]}\)], "Input"],

Cell[BoxData[
    \({{Dashing[{0.01`, 0.01`}], 
        Line[{{1, 0}, {1, 1}}]}, {Dashing[{0.01`, 0.01`}], 
        Line[{{4, 1}, {4, 0}}]}, {Dashing[{0.01`, 0.01`}], 
        Line[{{1.7`, 0}, {1.7`, 1.81`}}]}, Line[{{1, 1.81`}, {4, 1.81`}}], 
      Text[a1, {1, \(-0.2`\)}], Text[or, {0.2`, \(-0.2`\)}], 
      Text[a2, {4, \(-0.2`\)}], Text[a4, {3.4`, 1.1`}], Text[a3, {1.1`, 1}], 
      Text[a6, {2, 0.6`}], Text[a5, {1.7`, \(-0.2`\)}], 
      Text[a7, {1.5`, 2}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .59524 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0714286 0.238095 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .59674 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .07143 m
1 .07143 L
s
.14286 0 m
.14286 .59524 L
s
0 0 m
1 0 L
1 .59524 L
0 .59524 L
closepath
clip
newpath
.004 w
.2619 .30952 m
.29088 .37534 L
.32248 .42974 L
.33785 .45012 L
.35216 .46576 L
.36683 .47861 L
.3807 .48795 L
.38805 .49184 L
.39602 .49526 L
.40326 .49768 L
.40995 .49933 L
.41344 .49999 L
.4172 .50053 L
.41902 .50073 L
.42075 .50089 L
.4223 .501 L
.42399 .5011 L
.42504 .50114 L
.42603 .50117 L
.42692 .50118 L
.42788 .50119 L
.42837 .50119 L
.42892 .50119 L
.4295 .50118 L
.43003 .50117 L
.43099 .50115 L
.43201 .50111 L
.43297 .50106 L
.43401 .501 L
.43591 .50086 L
.43946 .5005 L
.4431 .49999 L
.44651 .49939 L
.45429 .4976 L
.46187 .49529 L
.47005 .49222 L
.48508 .48507 L
.5009 .4756 L
.52948 .45415 L
.55991 .42634 L
.58919 .39608 L
.62031 .36167 L
.6503 .3278 L
.67915 .29588 L
.70984 .2641 L
.73939 .237 L
.76781 .21548 L
.78361 .20589 L
.79806 .19884 L
.80521 .19601 L
Mistroke
.813 .19345 L
.82036 .19156 L
.82718 .19027 L
.831 .18976 L
.83315 .18954 L
.83512 .18938 L
.83686 .18927 L
.83784 .18923 L
.83876 .18919 L
.83973 .18917 L
.84062 .18915 L
.8411 .18915 L
.84164 .18914 L
.8426 .18915 L
.84346 .18916 L
.84428 .18918 L
.84516 .18921 L
.84612 .18925 L
.84807 .18937 L
.84986 .18951 L
.85313 .18987 L
.85656 .19038 L
.86033 .19109 L
.86374 .19189 L
.8714 .19419 L
.8785 .19698 L
.88519 .2002 L
.90023 .20963 L
.91407 .22112 L
.94367 .25535 L
.97212 .30174 L
.97619 .30952 L
Mfstroke
.5 Mabswid
[ .01 .01 ] 0 setdash
.2619 .07143 m
.2619 .30952 L
s
.97619 .30952 m
.97619 .07143 L
s
.42857 .07143 m
.42857 .50238 L
s
[ ] 0 setdash
.2619 .50238 m
.97619 .50238 L
s
gsave
.2619 .02381 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.07143 .02381 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(or) show
1.000 setlinewidth
grestore
gsave
.97619 .02381 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.83333 .33333 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.28571 .30952 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.5 .21429 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a6) show
1.000 setlinewidth
grestore
gsave
.42857 .02381 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
gsave
.38095 .54762 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a7) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 171.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000Za000`40O003h00Oogoo8Goo000YOol0
0`00Oomoo`3dOol002Uoo`03001oogoo0?Aoo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3d
Ool002Uoo`03001oogoo0?Aoo`004Goo0P000goo10003goo00<007ooOol06Woo1@0000=oo`000000
0`009Goo1@000Woo0P00Tgoo1@0000=oo`0000000P0017oo000@Ool01000Oomoo`000goo00<007oo
Ool03goo00<007ooOol06Woo100017oo00<007ooOol09Goo10000Woo00@007ooOol0099oo`@0009o
o`03001oogoo00Eoo`0047oo00@007ooOol000=oo`03001oogoo00moo`03001oogoo01eoo`03001o
ogoo009oo`03001oogoo02Qoo`03001oogoo00=oo`03001oogoo09=oo`05001oogooOol00006Ool0
015oo`8000=oo`@000moo`03001oogoo01]oo`<000Aoo`03001oogoo02Ioo`<000=oo`8009Aoo`<0
00Aoo`03001oogoo00=oo`00:Goo00<007ooOol08Woo00<007ooOol0;7oo00<007ooOol0V7oo00@0
07ooOol000Aoo`00:Goo00<007ooOol08Goo0P00;Woo0`00VGoo0P001Goo000YOol00`00Oomoo`3d
Ool002Uoo`03001oogoo0?Aoo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03
001oogoo0?Aoo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Ao
o`00:Goo00<007ooOol0m7oo00000goo0000003o000L0002Ool002Uoo`03001oogoo01moo`03001o
ogoo02eoo`03001oogoo0:9oo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0VGoo
00<007ooOol01Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`2IOol00`00Oomo
o`06Ool002Uoo`03001oogoo0>]oo`03001oogoo00Ioo`00:Goo00<007ooOol0jgoo00<007ooOol0
1Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`2ROol002Uoo`03001oogoo01mo
o`03001oogoo02eoo`03001oogoo0:9oo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007oo
Ool0VGoo00<007ooOol01Woo000YOol00`00Oomoo`3[Ool00`00Oomoo`06Ool002Uoo`03001oogoo
0>]oo`03001oogoo00Ioo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0VGoo00<0
07ooOol01Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`2ROol002Uoo`03001o
ogoo01moo`03001oogoo02eoo`03001oogoo0:9oo`00:Goo00<007ooOol07goo00<007ooOol0;Goo
00<007ooOol0VGoo00<007ooOol01Woo000YOol00`00Oomoo`3[Ool00`00Oomoo`06Ool002Uoo`03
001oogoo0>]oo`03001oogoo00Ioo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0
XWoo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`2ROol002Uoo`03001oogoo01mo
o`03001oogoo02eoo`03001oogoo09Uoo`03001oogoo00Ioo`00:Goo00<007ooOol07goo00<007oo
Ool0;Goo00<007ooOol0VGoo00<007ooOol01Woo000YOol00`00Oomoo`3[Ool00`00Oomoo`06Ool0
02Uoo`03001oogoo0>]oo`03001oogoo00Ioo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<0
07ooOol0XWoo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`2ROol002Uoo`03001o
ogoo01moo`03001oogoo02eoo`03001oogoo09Uoo`03001oogoo00Ioo`00:Goo00<007ooOol07goo
00<007ooOol0;Goo00<007ooOol0VGoo00<007ooOol01Woo000YOol00`00Oomoo`3[Ool00`00Oomo
o`06Ool002Uoo`03001oogoo01moo`03001oogoo02eoo`03001oogoo09Uoo`03001oogoo00Ioo`00
:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0XWoo000YOol00`00Oomoo`0OOol00`00
Oomoo`0]Ool00`00Oomoo`2ROol002Uoo`03001oogoo01moo`03001oogoo02eoo`03001oogoo09Uo
o`03001oogoo00Ioo`00:Goo00<007ooOol0jgoo00<007ooOol01Woo000YOol00`00Oomoo`32Ool5
000TOol00`00Oomoo`06Ool002Uoo`03001oogoo01moo`03001oogoo02eoo`03001oogoo06]oo`H0
00Aoo`H001ioo`03001oogoo00Ioo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0
Igoo100047oo0P009Goo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`1UOol2000F
Ool2000JOol00`00Oomoo`06Ool002Uoo`03001oogoo01moo`03001oogoo02eoo`03001oogoo06=o
o`8001Yoo`8001Qoo`03001oogoo00Ioo`00:Goo00<007ooOol0]7oo00<007ooOol077oo0P005Woo
00<007ooOol01Woo000YOol00`00Oomoo`1NOol5000017oo00000000Bgoo0P008Goo00<007ooOol0
4goo00<007ooOol01Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`0<Ool40002
Ool01000Oomoo`00B7oo0P0097oo00<007ooOol06goo000YOol00`00Oomoo`0OOol00`00Oomoo`0]
Ool00`00Oomoo`0?Ool01000Oomoo`000Woo00<007ooOol0AGoo00<007ooOol09Goo00<007ooOol0
6Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`0=Ool30002Ool30017Ool00`00
Oomoo`0WOol00`00Oomoo`0@Ool00`00Oomoo`06Ool002Uoo`03001oogoo01moo`03001oogoo02eo
o`03001oogoo01=oo`03001oogoo04Aoo`8002]oo`03001oogoo00moo`03001oogoo00Ioo`00:Goo
00<007ooOol0IGoo0`00@goo00<007ooOol0;7oo00<007ooOol03Woo00<007ooOol01Woo000YOol0
0`00Oomoo`2ZOol00`00Oomoo`0^Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool002Uoo`03001oogoo
01moo`03001oogoo02eoo`03001oogoo05Ioo`80039oo`03001oogoo01Eoo`00:Goo00<007ooOol0
7goo00<007ooOol0;Goo00<007ooOol0EGoo00<007ooOol0<goo00<007ooOol057oo000YOol00`00
Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`1DOol00`00Oomoo`0dOol00`00Oomoo`0;Ool00`00
Oomoo`06Ool002Uoo`03001oogoo0:Eoo`03001oogoo03Ioo`03001oogoo00Yoo`03001oogoo00Io
o`00:Goo00<007ooOol0Y7oo00<007ooOol0>7oo00<007ooOol02Goo00<007ooOol01Woo000YOol0
0`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`1AOol00`00Oomoo`0jOol00`00Oomoo`08Ool0
0`00Oomoo`06Ool002Uoo`03001oogoo01moo`03001oogoo02eoo`03001oogoo051oo`03001oogoo
03aoo`03001oogoo011oo`00:Goo00<007ooOol07goo00<007ooOol0;Goo00<007ooOol0Cgoo00<0
07ooOol0?Woo00<007ooOol03goo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`1>
Ool00`00Oomoo`0oOol00`00Oomoo`06Ool00`00Oomoo`06Ool002Uoo`03001oogoo09moo`03001o
ogoo045oo`03001oogoo00Eoo`03001oogoo00Ioo`00:Goo00<007ooOol0WWoo00<007ooOol0@Woo
00<007ooOol01Goo00<007ooOol01Woo000YOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomo
o`1;Ool00`00Oomoo`14Ool00`00Oomoo`0=Ool002Uoo`03001oogoo01moo`03001oogoo02eoo`03
001oogoo04Yoo`03001oogoo04Ioo`03001oogoo00aoo`00:Goo00<007ooOol07goo00<007ooOol0
;Goo00<007ooOol0BGoo00<007ooOol0Agoo00<007ooOol00goo00<007ooOol01Woo000YOol00`00
Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`18Ool00`00Oomoo`19Ool00`00Oomoo`02Ool00`00
Oomoo`06Ool002Uoo`03001oogoo09Uoo`03001oogoo04]oo`05001oogooOol00008Ool002Uoo`03
001oogoo09Qoo`03001oogoo04aoo`05001oogooOol00008Ool002Uoo`03001oogoo01moo`03001o
ogoo02eoo`03001oogoo04Eoo`03001oogoo04ioo`03001oogoo00Uoo`00:Goo00<007ooOol07goo
00<007ooOol0;Goo00<007ooOol0A7oo00<007ooOol0Cgoo00<007ooOol02Goo000YOol00`00Oomo
o`0OOol00`00Oomoo`0]Ool00`00Oomoo`13Ool00`00Oomoo`1AOol00`00Ool00008Ool002Uoo`03
001oogoo025oo`D0009oo`8006Yoo`03001oogoo05=oo`8000Qoo`00:Goo00<007ooOol08Goo1000
0Woo00@007ooOol006Qoo`03001oogoo05Aoo`8000Qoo`00:Goo00<007ooOol07goo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol08goo00<007ooOol0@7oo00<007ooOol0EWoo00<007ooOol0
1Woo000YOol00`00Oomoo`0OOol00`00Oomoo`030005Ool00`00Oomoo`0ROol00`00Oomoo`10Ool0
0`00Oomoo`1OOol002Uoo`03001oogoo021oo`03001oogoo00Aoo`04001oogoo000TOol00`00Oomo
o`0oOol00`00Oomoo`1POol002Uoo`03001oogoo021oo`03001oogoo00Eoo`8002Eoo`03001oogoo
03ioo`03001oogoo065oo`00:Goo00<007ooOol08Goo00<007ooOol0Jgoo00<007ooOol0HWoo000Y
Ool00`00Oomoo`0QOol00`00Oomoo`1ZOol00`00Oomoo`0/Ool50003Ool3000/Ool002Uoo`03001o
ogoo029oo`03001oogoo02Yoo`03001oogoo03]oo`03001oogoo02eoo`@000Eoo`03001oogoo02]o
o`00:Goo00<007ooOol08Woo00<007ooOol0:Woo00<007ooOol0>Woo00<007ooOol0<Goo00<007oo
Ool01@00;7oo000YOol00`00Oomoo`0SOol00`00Oomoo`0YOol00`00Oomoo`0iOol00`00Oomoo`0`
Ool30002Ool01000Oomoo`00;Goo000YOol00`00Oomoo`0SOol00`00Oomoo`0YOol00`00Oomoo`0h
Ool00`00Oomoo`0gOol00`00Ool0000]Ool002Uoo`03001oogoo02=oo`03001oogoo06Aoo`03001o
ogoo03Qoo`8002eoo`00:Goo00<007ooOol097oo00<007ooOol0HWoo00<007ooOol0J7oo000YOol0
0`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomoo`0fOol00`00Oomoo`1YOol002Uoo`03001oogoo
02Eoo`03001oogoo02Moo`03001oogoo03Eoo`03001oogoo06Yoo`00:Goo00<007ooOol09Goo00<0
07ooOol09goo00<007ooOol0=7oo00<007ooOol0Jgoo000YOol00`00Oomoo`0VOol00`00Oomoo`0V
Ool00`00Oomoo`0cOol00`00Oomoo`1/Ool002Uoo`03001oogoo02Ioo`03001oogoo05]oo`03001o
ogoo06eoo`00:Goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol0<Goo00<007ooOol0KWoo
000YOol00`00Oomoo`0WOol00`00Oomoo`0UOol00`00Oomoo`0`Ool00`00Oomoo`1_Ool002Uoo`03
001oogoo02Qoo`03001oogoo02Aoo`03001oogoo02moo`03001oogoo071oo`00:Goo00<007ooOol0
:7oo00<007ooOol097oo00<007ooOol0;Woo00<007ooOol0LGoo000YOol00`00Oomoo`0YOol00`00
Oomoo`1COol00`00Oomoo`1bOol002Uoo`03001oogoo02Uoo`03001oogoo059oo`03001oogoo07=o
o`00:Goo00<007ooOol0:Woo00<007ooOol08Woo00<007ooOol0:goo00<007ooOol0M7oo000YOol0
0`00Oomoo`0ZOol00`00Oomoo`0ROol00`00Oomoo`0ZOol00`00Oomoo`1eOol002Uoo`03001oogoo
02]oo`03001oogoo025oo`03001oogoo02Uoo`03001oogoo07Ioo`00:Goo00<007ooOol0;7oo00<0
07ooOol087oo00<007ooOol0:7oo00<007ooOol0Mgoo000YOol00`00Oomoo`0/Ool00`00Oomoo`1:
Ool00`00Oomoo`1hOol002Uoo`03001oogoo02eoo`03001oogoo04Qoo`03001oogoo07Uoo`00:Goo
00<007ooOol0;Goo00<007ooOol07goo00<007ooOol09Woo00<007ooOol0NGoo000YOol00`00Oomo
o`0^Ool00`00Oomoo`0NOol00`00Oomoo`0UOol00`00Oomoo`1jOol002Uoo`03001oogoo02ioo`03
001oogoo01ioo`03001oogoo02Aoo`03001oogoo07]oo`00:Goo00<007ooOol0;goo00<007ooOol0
7Goo00<007ooOol08goo00<007ooOol0O7oo000YOol00`00Oomoo`0_Ool00`00Oomoo`12Ool00`00
Oomoo`1mOol002Uoo`03001oogoo031oo`03001oogoo01aoo`03001oogoo025oo`03001oogoo07io
o`00:Goo00<007ooOol0<Goo00<007ooOol06goo00<007ooOol087oo00<007ooOol0Ogoo000YOol0
0`00Oomoo`0bOol00`00Oomoo`0JOol00`00Oomoo`0OOol00`00Oomoo`20Ool002Uoo`03001oogoo
039oo`03001oogoo01Yoo`03001oogoo01eoo`8008=oo`00:Goo00<007ooOol0<goo00<007ooOol0
>7oo00<007ooOol0Pgoo000YOol00`00Oomoo`0dOol00`00Oomoo`0fOol00`00Oomoo`24Ool002Uo
o`03001oogoo03Eoo`03001oogoo01Moo`03001oogoo01Yoo`03001oogoo08Eoo`00:Goo00<007oo
Ool0=Woo00<007ooOol05Woo00<007ooOol06Goo00<007ooOol0QWoo000YOol00`00Oomoo`0gOol0
0`00Oomoo`0EOol00`00Oomoo`0HOol00`00Oomoo`27Ool002Uoo`03001oogoo03Qoo`03001oogoo
01Aoo`03001oogoo01Ioo`8008Yoo`00:Goo00<007ooOol0>Goo00<007ooOol0:goo00<007ooOol0
RWoo000YOol00`00Oomoo`0jOol00`00Oomoo`0YOol00`00Oomoo`2;Ool002Uoo`03001oogoo03]o
o`03001oogoo015oo`03001oogoo019oo`8008ioo`00:Goo00<007ooOol0?7oo00<007ooOol047oo
00<007ooOol04Goo00<007ooOol0SWoo000YOol00`00Oomoo`0mOol00`00Oomoo`0?Ool00`00Oomo
o`0@Ool00`00Oomoo`2?Ool002Uoo`03001oogoo03ioo`8000moo`03001oogoo00ioo`80099oo`00
:Goo00<007ooOol0@7oo00<007ooOol06goo0P00U7oo000YOol00`00Oomoo`11Ool2000IOol2002F
Ool002Uoo`03001oogoo04=oo`8000Yoo`03001oogoo00Moo`<009Qoo`00:Goo00<007ooOol0AGoo
10001Woo00<007ooOol00goo1000Vgoo000YOol00`00Oomoo`19Ool<002OOol002Uoo`03001oogoo
01moold000Qoo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Ao
o`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Aoo`00:Goo00<0
07ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Aoo`00:Goo00<007ooOol0m7oo
000YOol00`00Oomoo`0lOol50003Ool00`00Oomoo`2]Ool002Uoo`03001oogoo03aoo`@000Aoo`03
001oogoo0:eoo`00:Goo00<007ooOol0?goo00<007ooOol00Woo00<007ooOol0[Goo000YOol00`00
Oomoo`0mOol30005Ool00`00Oomoo`2/Ool002Uoo`03001oogoo049oo`04001oogoo002^Ool002Uo
o`03001oogoo049oo`@00:ioo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03
001oogoo0?Aoo`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Ao
o`00:Goo00<007ooOol0m7oo000YOol00`00Oomoo`3dOol002Uoo`03001oogoo0?Aoo`00:Goo00<0
07ooOol0m7oo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {170.375, 0}} -> {-0.11629, -0.306313, \
0.0147477, 0.0147477}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<Rolle.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 140, 2, 50, "Input"],
Cell[1882, 55, 189, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2108, 63, 45, 1, 30, "Input"],
Cell[2156, 66, 81, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2274, 72, 292, 6, 50, "Input"],
Cell[2569, 80, 7797, 206, 184, 2007, 130, "GraphicsData", "PostScript", \
"Graphics"],
Cell[10369, 288, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10536, 296, 476, 8, 90, "Input"],
Cell[11015, 306, 481, 8, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11533, 319, 53, 1, 30, "Input"],
Cell[11589, 322, 17562, 512, 180, 7016, 377, "GraphicsData", "PostScript", \
"Graphics"],
Cell[29154, 836, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29321, 844, 75, 1, 30, "Input"],
Cell[29399, 847, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

